#ifndef DX_VOS_SIM_UTILS_H
#define DX_VOS_SIM_UTILS_H

#include "VOS_API/DX_VOS_BaseTypes.h"
#ifdef __cplusplus
extern "C"
{
#endif

#pragma pack(push, 1)
typedef struct  
{
    DxUint8 m_Class;
    DxUint8 m_Instruction;
    DxUint8 m_P1;
    DxUint8 m_P2;
    DxUint8 m_DataSize;
    DxUint8 m_Data[256];
} DxApdu;
#pragma pack(pop)

DxStatus DX_VOS_SimInit(const DxChar* cardReaderName);

void DX_VOS_SimTerminate();

DxStatus DX_VOS_ExecuteApdu(const DxApdu* cmd, DxUint32* status, void* responseData, DxUint32 dataMaxSize, DxUint32* dataActuallyRead);

#ifdef __cplusplus
}
#endif

#endif